/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.ontology.InvalidTermException;
import org.biojava.ontology.Term;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RankedCrossRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichFeatureRelationship;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimpleRichFeatureRelationship;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichFeature
extends AbstractChangeable
implements RichFeature {
    private static int nextRank = 0;
    private RichAnnotation notes = new SimpleRichAnnotation();
    private ComparableTerm typeTerm;
    private ComparableTerm sourceTerm;
    private FeatureHolder parent;
    private RichLocation location = RichLocation.EMPTY_LOCATION;
    private Set crossrefs = new TreeSet();
    private Set relations = new TreeSet();
    private String name;
    private int rank = nextRank++;
    private Set locsSet = new TreeSet();
    private Integer id;

    public SimpleRichFeature(FeatureHolder parent, Feature.Template templ) throws ChangeVetoException, InvalidTermException {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        if (templ == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        if (templ.type == null && templ.typeTerm == null) {
            throw new IllegalArgumentException("Template type cannot be null");
        }
        if (templ.source == null && templ.sourceTerm == null) {
            throw new IllegalArgumentException("Template source cannot be null");
        }
        if (templ.location == null) {
            throw new IllegalArgumentException("Template location cannot be null");
        }
        this.setParent(parent);
        this.setLocation(templ.location);
        if (templ.typeTerm != null) {
            this.setTypeTerm(templ.typeTerm);
        } else {
            this.setType(templ.type);
        }
        if (templ.sourceTerm != null) {
            this.setSourceTerm(templ.sourceTerm);
        } else {
            this.setSource(templ.source);
        }
        if (templ.annotation instanceof RichAnnotation) {
            this.notes.setNoteSet(((RichAnnotation)templ.annotation).getNoteSet());
        } else {
            this.notes = new SimpleRichAnnotation();
            for (Object key : templ.annotation.keys()) {
                this.notes.setProperty(key, templ.annotation.getProperty(key));
            }
        }
        if (templ instanceof RichFeature.Template) {
            this.setRankedCrossRefs(((RichFeature.Template)templ).rankedCrossRefs);
            this.setFeatureRelationshipSet(((RichFeature.Template)templ).featureRelationshipSet);
        }
    }

    protected SimpleRichFeature() {
    }

    public Feature.Template makeTemplate() {
        RichFeature.Template templ = new RichFeature.Template();
        templ.annotation = this.notes;
        templ.featureRelationshipSet = this.relations;
        templ.rankedCrossRefs = this.crossrefs;
        templ.location = this.location;
        templ.sourceTerm = this.sourceTerm;
        templ.source = this.sourceTerm.getName();
        templ.typeTerm = this.typeTerm;
        templ.type = this.typeTerm.getName();
        return templ;
    }

    public Annotation getAnnotation() {
        return this.getRichAnnotation();
    }

    public RichAnnotation getRichAnnotation() {
        return this.notes;
    }

    public Set getNoteSet() {
        return this.notes.getNoteSet();
    }

    public void setNoteSet(Set notes) throws ChangeVetoException {
        this.notes.setNoteSet(notes);
    }

    Set getLocationSet() {
        SimpleRichFeature.setTerm(this.locsSet, null);
        Collection<Location> newlocs = RichLocation.Tools.flatten(this.location);
        this.locsSet.retainAll(newlocs);
        this.locsSet.addAll(newlocs);
        SimpleRichFeature.setTerm(this.locsSet, ((RichLocation)this.getLocation()).getTerm());
        return this.locsSet;
    }

    private static final void setTerm(Collection theCollection, ComparableTerm theTerm) {
        for (RichLocation location : theCollection) {
            try {
                location.setTerm(theTerm);
            }
            catch (Exception e) {
                throw new RuntimeException("SimpleRichFeature.setTerm-unable to set term <" + theTerm + "> in location <" + location + ">" + e);
            }
        }
    }

    void setLocationSet(Set locs) throws ChangeVetoException {
        this.locsSet = locs;
        this.location = RichLocation.Tools.construct(RichLocation.Tools.merge(locs));
        if (locs.size() > 0) {
            this.location.setTerm(((RichLocation)locs.iterator().next()).getTerm());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws ChangeVetoException {
        if (!this.hasListeners(RichFeature.NAME)) {
            this.name = name;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.NAME, name, this.name);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.NAME);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.name = name;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRank(int rank) throws ChangeVetoException {
        if (!this.hasListeners(RichFeature.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getRank() {
        return this.rank;
    }

    public Sequence getSequence() {
        FeatureHolder p = this.parent;
        while (p instanceof Feature) {
            p = ((Feature)p).getParent();
        }
        return (Sequence)p;
    }

    public String getSource() {
        return this.sourceTerm.getName();
    }

    public void setSource(String source) throws ChangeVetoException {
        try {
            this.setSourceTerm(RichObjectFactory.getDefaultOntology().getOrCreateTerm(source));
        }
        catch (InvalidTermException e) {
            throw new ChangeVetoException("Source term was rejected by the default ontology", e);
        }
    }

    public Term getSourceTerm() {
        return this.sourceTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceTerm(Term t) throws ChangeVetoException, InvalidTermException {
        if (t == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        ComparableTerm comparableT = t instanceof ComparableTerm ? (ComparableTerm)t : RichObjectFactory.getDefaultOntology().getOrImportTerm(t);
        if (!this.hasListeners(RichFeature.SOURCETERM)) {
            this.sourceTerm = comparableT;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.SOURCETERM, comparableT, this.sourceTerm);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.SOURCETERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.sourceTerm = comparableT;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public String getType() {
        return this.typeTerm.getName();
    }

    public void setType(String type) throws ChangeVetoException {
        try {
            this.setTypeTerm(RichObjectFactory.getDefaultOntology().getOrCreateTerm(type));
        }
        catch (InvalidTermException e) {
            throw new ChangeVetoException("Type term was rejected by the default ontology", e);
        }
    }

    public Term getTypeTerm() {
        return this.typeTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeTerm(Term t) throws ChangeVetoException, InvalidTermException {
        if (t == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        ComparableTerm comparableT = t instanceof ComparableTerm ? (ComparableTerm)t : RichObjectFactory.getDefaultOntology().getOrImportTerm(t);
        if (!this.hasListeners(RichFeature.TYPETERM)) {
            this.typeTerm = comparableT;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.TYPETERM, comparableT, this.typeTerm);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.TYPETERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.typeTerm = comparableT;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public SymbolList getSymbols() {
        return this.location.symbols(this.getSequence());
    }

    public Location getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(Location loc) throws ChangeVetoException {
        if (loc == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        RichLocation richLoc = RichLocation.Tools.enrich(loc);
        if (!this.hasListeners(RichFeature.LOCATION)) {
            this.location = richLoc;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.LOCATION, richLoc, this.location);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.LOCATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.location = richLoc;
                cs.firePostChangeEvent(ce);
            }
        }
        this.location.setFeature(this);
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(FeatureHolder parent) throws ChangeVetoException {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        if (!this.hasListeners(RichFeature.PARENT)) {
            this.parent = parent;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.PARENT, parent, this.parent);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.PARENT);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.parent = parent;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Set getRankedCrossRefs() {
        return this.crossrefs;
    }

    public void setRankedCrossRefs(Set crossrefs) throws ChangeVetoException {
        this.crossrefs = crossrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRankedCrossRef(RankedCrossRef crossref) throws ChangeVetoException {
        if (crossref == null) {
            throw new IllegalArgumentException("Crossref cannot be null");
        }
        if (!this.hasListeners(RichFeature.CROSSREF)) {
            this.crossrefs.add(crossref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.CROSSREF, crossref, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.CROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.crossrefs.add(crossref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRankedCrossRef(RankedCrossRef crossref) throws ChangeVetoException {
        if (crossref == null) {
            throw new IllegalArgumentException("Crossref cannot be null");
        }
        if (!this.hasListeners(RichFeature.CROSSREF)) {
            this.crossrefs.remove(crossref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.CROSSREF, null, crossref);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.CROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.crossrefs.remove(crossref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Set getFeatureRelationshipSet() {
        return this.relations;
    }

    public void setFeatureRelationshipSet(Set relationships) throws ChangeVetoException {
        this.relations = relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureRelationship(RichFeatureRelationship relationship) throws ChangeVetoException {
        if (relationship == null) {
            throw new IllegalArgumentException("Relationship cannot be null");
        }
        if (!this.hasListeners(RichFeature.RELATION)) {
            this.relations.add(relationship);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.RELATION, relationship, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.RELATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.relations.add(relationship);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatureRelationship(RichFeatureRelationship relationship) throws ChangeVetoException {
        if (relationship == null) {
            throw new IllegalArgumentException("Relationship cannot be null");
        }
        if (!this.hasListeners(RichFeature.RELATION)) {
            this.relations.remove(relationship);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeature.RELATION, null, relationship);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeature.RELATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.relations.remove(relationship);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    private Set relationsToFeatureSet() {
        TreeSet<RichFeature> features = new TreeSet<RichFeature>();
        for (RichFeatureRelationship r : this.relations) {
            features.add(r.getSubject());
        }
        return features;
    }

    public boolean containsFeature(Feature f) {
        return this.relationsToFeatureSet().contains(f);
    }

    public int countFeatures() {
        return this.relationsToFeatureSet().size();
    }

    public Feature createFeature(Feature.Template ft) throws BioException, ChangeVetoException {
        SimpleRichFeature f;
        if (ft == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        try {
            f = new SimpleRichFeature(this.parent, ft);
        }
        catch (InvalidTermException e) {
            throw new ChangeVetoException("Term was not accepted", e);
        }
        this.addFeatureRelationship(new SimpleRichFeatureRelationship(this, f, SimpleRichFeatureRelationship.getContainsTerm(), 0));
        return f;
    }

    public Iterator features() {
        return this.relationsToFeatureSet().iterator();
    }

    public FeatureHolder filter(FeatureFilter filter) {
        boolean recurse = !FilterUtils.areProperSubset(filter, FeatureFilter.top_level);
        return this.filter(filter, recurse);
    }

    public FeatureHolder filter(FeatureFilter fc, boolean recurse) {
        SimpleFeatureHolder fh = new SimpleFeatureHolder();
        Iterator i = this.features();
        while (i.hasNext()) {
            RichFeature f = (RichFeature)i.next();
            try {
                if (!fc.accept(f)) continue;
                fh.addFeature(f);
            }
            catch (ChangeVetoException e) {
                throw new RuntimeException("Aaargh! Our feature was rejected!", e);
            }
        }
        return fh;
    }

    public FeatureFilter getSchema() {
        return FeatureFilter.all;
    }

    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        Iterator i = this.relations.iterator();
        while (i.hasNext()) {
            RichFeatureRelationship r = (RichFeatureRelationship)i.next();
            if (!r.getSubject().equals(f)) continue;
            i.remove();
        }
    }

    public void setStrand(StrandedFeature.Strand strand) throws ChangeVetoException {
        throw new ChangeVetoException("The strand is immutable on RichFeature objects.");
    }

    public StrandedFeature.Strand getStrand() {
        RichLocation.Strand s = this.location.getStrand();
        if (s.equals(RichLocation.Strand.NEGATIVE_STRAND)) {
            return StrandedFeature.NEGATIVE;
        }
        if (s.equals(RichLocation.Strand.POSITIVE_STRAND)) {
            return StrandedFeature.POSITIVE;
        }
        return StrandedFeature.UNKNOWN;
    }

    public int hashCode() {
        int code = 17;
        if (this.parent == null) {
            return code;
        }
        code = 31 * code + this.rank;
        code = 31 * code + this.parent.hashCode();
        code = 31 * code + this.sourceTerm.hashCode();
        code = 31 * code + this.typeTerm.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        int theirRank;
        if (!(o instanceof Feature)) {
            return false;
        }
        if (this.parent == null) {
            return false;
        }
        Feature fo = (Feature)o;
        int ourRank = this.getRank();
        int n = theirRank = fo instanceof RichFeature ? ((RichFeature)fo).getRank() : 0;
        if (ourRank != theirRank) {
            return false;
        }
        if (!this.parent.equals(fo.getParent())) {
            return false;
        }
        if (!this.typeTerm.equals(fo.getTypeTerm())) {
            return false;
        }
        return this.sourceTerm.equals(fo.getSourceTerm());
    }

    public int compareTo(Object o) {
        int theirRank;
        if (o == this) {
            return 0;
        }
        if (this.parent == null) {
            return -1;
        }
        Feature them = (Feature)o;
        int ourRank = this.getRank();
        int n = theirRank = them instanceof RichFeature ? ((RichFeature)them).getRank() : 0;
        if (ourRank != theirRank) {
            return ourRank - theirRank;
        }
        if (this.parent instanceof Comparable && them.getParent() instanceof Comparable && !this.parent.equals(them.getParent())) {
            return ((Comparable)((Object)this.parent)).compareTo(them.getParent());
        }
        if (!this.typeTerm.equals(them.getTypeTerm())) {
            return this.typeTerm.compareTo(them.getTypeTerm());
        }
        if (!this.sourceTerm.equals(them.getSourceTerm())) {
            return this.sourceTerm.compareTo(them.getSourceTerm());
        }
        if (this.parent.equals(them.getParent())) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.parent + ":" + this.getType() + "," + this.getSource() + "(" + this.location + ")";
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

