/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Note;
import org.biojavax.ontology.ComparableTerm;

public class SimpleNote
extends AbstractChangeable
implements Note {
    private ComparableTerm term;
    private String value;
    private int rank;

    public SimpleNote(ComparableTerm term, String value, int rank) {
        if (term == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        this.term = term;
        this.value = value;
        this.rank = rank;
    }

    protected SimpleNote() {
    }

    public ComparableTerm getTerm() {
        return this.term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerm(ComparableTerm term) throws ChangeVetoException {
        if (term == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        if (term.equals(this.term)) {
            return;
        }
        if (!this.hasListeners(Note.TERM)) {
            this.term = term;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Note.TERM, term, this.term);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Note.TERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.term = term;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String value) throws ChangeVetoException {
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        if (this.value == null && value == null) {
            return;
        }
        if (!this.hasListeners(Note.VALUE)) {
            this.value = value;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Note.VALUE, value, this.value);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Note.VALUE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.value = value;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getRank() {
        return this.rank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRank(int rank) throws ChangeVetoException {
        if (this.rank == rank) {
            return;
        }
        if (!this.hasListeners(Note.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Note.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(Note.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.term == null) {
            return -1;
        }
        Note them = (Note)o;
        if (this.rank != them.getRank()) {
            return this.rank - them.getRank();
        }
        return this.term.compareTo(them.getTerm());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Note)) {
            return false;
        }
        if (this.term == null) {
            return false;
        }
        Note them = (Note)o;
        return this.term.equals(them.getTerm()) && this.rank == them.getRank();
    }

    public int hashCode() {
        int hash = 17;
        if (this.term == null) {
            return hash;
        }
        hash = 31 * hash + this.term.hashCode();
        hash = 31 * hash + this.rank;
        return hash;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.term + ": " + this.value;
    }
}

