/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.taxa;

import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.taxa.CircularReferenceException;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.TaxonFactory;
import org.biojava.bio.taxa.TaxonParser;
import org.biojava.utils.ChangeVetoException;

public class EbiFormat
implements TaxonParser {
    public static final String PROPERTY_NCBI_TAXON = EbiFormat.class + ":NCBI_TAXON";
    public static final String PROPERTY_TAXON_NAMES = EbiFormat.class + ":TAXON_NAMES";
    private static EbiFormat INSTANCE = new EbiFormat();

    public static final EbiFormat getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EbiFormat();
        }
        return INSTANCE;
    }

    public Taxon parse(TaxonFactory taxonFactory, String taxonString) throws ChangeVetoException, CircularReferenceException {
        String name = taxonString.trim();
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        Taxon taxon = taxonFactory.getRoot();
        StringTokenizer sTok = new StringTokenizer(name, ";");
        if (sTok.countTokens() == 1) {
            return taxonFactory.addChild(taxon, taxonFactory.createTaxon(name, null));
        }
        String tok = null;
        block0: while (sTok.hasMoreTokens()) {
            tok = sTok.nextToken().trim();
            for (Taxon child : taxon.getChildren()) {
                if (!child.getScientificName().equals(tok)) continue;
                taxon = child;
                continue block0;
            }
        }
        while (sTok.hasMoreTokens()) {
            taxon = taxonFactory.addChild(taxon, taxonFactory.createTaxon(tok, null));
            tok = sTok.nextToken().trim();
        }
        return taxon;
    }

    public String serialize(Taxon taxon) {
        String name = null;
        do {
            String sci = taxon.getScientificName();
            name = name == null ? sci + "." : sci + "; " + name;
        } while ((taxon = taxon.getParent()) != null && taxon.getParent() != null);
        return name;
    }

    public String serializeSource(Taxon taxon) {
        StringBuffer sb = new StringBuffer(taxon.getScientificName());
        String common = taxon.getCommonName();
        if (common != null && common.length() > 0) {
            sb.append(" (").append(taxon.getCommonName()).append(")");
        }
        sb.append('.');
        return sb.toString();
    }

    public String serializeXRef(Taxon taxon) {
        Annotation anno = taxon.getAnnotation();
        Object t = anno.getProperty(PROPERTY_NCBI_TAXON);
        if (t instanceof List) {
            t = (String)((List)t).get(0);
        }
        return "NCBI_TaxID=" + t + ";";
    }
}

