/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.impl.SimpleStrandedFeature;

public class SimpleRemoteFeature
extends SimpleStrandedFeature
implements RemoteFeature,
Serializable {
    private List regions;
    private RemoteFeature.Resolver resolver;

    public List getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public RemoteFeature.Resolver getResolver() {
        return this.resolver;
    }

    public Feature getRemoteFeature() throws BioException {
        return this.getResolver().resolve(this);
    }

    public Feature.Template makeTemplate() {
        RemoteFeature.Template rt = new RemoteFeature.Template();
        this.fillTemplate(rt);
        return rt;
    }

    protected void fillTemplate(RemoteFeature.Template rt) {
        super.fillTemplate(rt);
        rt.resolver = this.getResolver();
        rt.regions = new ArrayList(this.getRegions());
    }

    public SimpleRemoteFeature(Sequence sourceSeq, FeatureHolder parent, RemoteFeature.Template template) {
        super(sourceSeq, parent, template);
        this.regions = new ArrayList(template.regions);
        this.resolver = template.resolver;
    }

    public static class DBResolver
    implements RemoteFeature.Resolver {
        private SequenceDB seqDB;

        public SequenceDB getSeqDB() {
            return this.seqDB;
        }

        public DBResolver(SequenceDB seqDB) {
            this.seqDB = seqDB;
        }

        public Feature resolve(RemoteFeature rFeat) throws BioException {
            FeatureFilter.ByClass remoteFilter = new FeatureFilter.ByClass(RemoteFeature.class);
            HashSet<Sequence> seqs = new HashSet<Sequence>();
            LinkedList<Sequence> ids = new LinkedList<Sequence>();
            HashSet<RemoteFeature> feats = new HashSet<RemoteFeature>();
            Sequence parent = rFeat.getSequence();
            ids.add(parent);
            while (!ids.isEmpty()) {
                Sequence seq = (Sequence)ids.removeFirst();
                seqs.add(seq);
                FeatureHolder remotes = seq.filter(remoteFilter, false);
                Iterator<Feature> fi = remotes.features();
                while (fi.hasNext()) {
                    RemoteFeature rf = (RemoteFeature)fi.next();
                    feats.add(rf);
                    for (RemoteFeature.Region r : rf.getRegions()) {
                        Sequence rseq;
                        if (!r.isRemote() || ids.contains(rseq = this.getSeqDB().getSequence(r.getSeqID())) || seqs.contains(rseq)) continue;
                        ids.addLast(rseq);
                    }
                }
            }
            StringBuffer nameBuff = new StringBuffer();
            Iterator si = seqs.iterator();
            Sequence nextSeq = (Sequence)si.next();
            nameBuff.append(nextSeq.getName());
            while (si.hasNext()) {
                nextSeq = (Sequence)si.next();
                nameBuff.append("-");
                nameBuff.append(nextSeq.getName());
            }
            return null;
        }
    }
}

