/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFeatureHolder
extends AbstractFeatureHolder
implements Serializable {
    private List features = new ArrayList();
    private FeatureFilter schema;

    public SimpleFeatureHolder() {
        this.schema = FeatureFilter.all;
    }

    public SimpleFeatureHolder(FeatureFilter schema) {
        this.schema = schema;
    }

    protected List getFeatures() {
        return this.features;
    }

    @Override
    public int countFeatures() {
        return this.features.size();
    }

    @Override
    public Iterator<Feature> features() {
        return ListTools.nonRemoveIterator(this.features.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(Feature f) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.features.add(f);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FeatureHolder.FEATURES);
            synchronized (changeSupport2) {
                ChangeEvent ce;
                ChangeEvent changeEvent = ce = new ChangeEvent(this, FeatureHolder.FEATURES, f, null);
                synchronized (changeEvent) {
                    changeSupport.firePreChangeEvent(ce);
                }
                this.features.add(f);
                changeEvent = ce;
                synchronized (changeEvent) {
                    changeSupport.firePostChangeEvent(ce);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeature(Feature f) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.features.remove(f);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FeatureHolder.FEATURES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, FeatureHolder.FEATURES, null, f);
                changeSupport.firePreChangeEvent(ce);
                this.features.remove(f);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.features.contains(f);
    }

    @Override
    public FeatureFilter getSchema() {
        return this.schema;
    }
}

