/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.utils.ChangeVetoException;

public class FeatureHolderUtils {
    public static FeatureHolder union(FeatureHolder fh1, FeatureHolder fh2) throws ChangeVetoException {
        int s2;
        int s1 = fh1.countFeatures();
        if (s1 < (s2 = fh2.countFeatures())) {
            return FeatureHolderUtils.unionOp(fh2, fh1);
        }
        return FeatureHolderUtils.unionOp(fh1, fh2);
    }

    private static FeatureHolder unionOp(FeatureHolder fh1, FeatureHolder fh2) throws ChangeVetoException {
        SimpleFeatureHolder res = new SimpleFeatureHolder();
        Iterator<Feature> it = fh1.features();
        while (it.hasNext()) {
            res.addFeature(it.next());
        }
        it = fh2.features();
        while (it.hasNext()) {
            Feature f = it.next();
            if (res.containsFeature(f)) continue;
            res.addFeature(f);
        }
        return res;
    }

    public static FeatureHolder intersect(FeatureHolder fh1, FeatureHolder fh2) throws ChangeVetoException {
        int s2;
        int s1 = fh1.countFeatures();
        if (s1 < (s2 = fh2.countFeatures())) {
            return FeatureHolderUtils.intersectOp(fh1, fh2);
        }
        return FeatureHolderUtils.intersectOp(fh2, fh1);
    }

    private static FeatureHolder intersectOp(FeatureHolder fh1, FeatureHolder fh2) throws ChangeVetoException {
        SimpleFeatureHolder res = new SimpleFeatureHolder();
        Iterator<Feature> it = fh1.features();
        while (it.hasNext()) {
            Feature f = it.next();
            if (!fh2.containsFeature(f)) continue;
            res.addFeature(f);
        }
        return res;
    }

    public static FeatureHolder not(FeatureHolder fh1, FeatureHolder fh2) throws ChangeVetoException {
        SimpleFeatureHolder res = new SimpleFeatureHolder();
        Iterator<Feature> it = fh1.features();
        while (it.hasNext()) {
            Feature f = it.next();
            if (fh2.containsFeature(f)) continue;
            res.addFeature(f);
        }
        return res;
    }

    public static Set featureHolderAsSet(FeatureHolder fh) {
        return new FeatureHolderAsSet(fh);
    }

    private static final class FeatureHolderAsSet
    extends HashSet {
        FeatureHolderAsSet(FeatureHolder fh) {
            Iterator<Feature> it = fh.features();
            while (it.hasNext()) {
                this.add(it.next());
            }
        }
    }
}

