/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class SimpleDistributionTrainerContext
implements DistributionTrainerContext,
Serializable {
    private final Map distToTrainer = new IdentityHashMap();
    private final Set trainers = new HashSet();
    private double nullModelWeight;

    public double getNullModelWeight() {
        return this.nullModelWeight;
    }

    public void setNullModelWeight(double nullModelWeight) {
        this.nullModelWeight = nullModelWeight;
    }

    public void registerDistribution(Distribution dist) {
        if (!this.distToTrainer.keySet().contains(dist)) {
            dist.registerWithTrainer(this);
        }
    }

    public void registerTrainer(Distribution dist, DistributionTrainer trainer) {
        this.distToTrainer.put(dist, trainer);
        this.trainers.add(trainer);
    }

    public DistributionTrainer getTrainer(Distribution dist) {
        return (DistributionTrainer)this.distToTrainer.get(dist);
    }

    public void addCount(Distribution dist, Symbol sym, double times) throws IllegalSymbolException {
        DistributionTrainer dt = this.getTrainer(dist);
        if (dt == null) {
            throw new NullPointerException("No trainer associated with distribution " + dist);
        }
        if (sym instanceof AtomicSymbol) {
            dt.addCount(this, (AtomicSymbol)sym, times);
        } else {
            Iterator<Symbol> asi = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (asi.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)asi.next();
                dt.addCount(this, as, times);
            }
        }
    }

    public double getCount(Distribution dist, Symbol sym) throws IllegalSymbolException {
        DistributionTrainer dt = this.getTrainer(dist);
        if (dt == null) {
            throw new NullPointerException("No trainer associated with distribution " + dist);
        }
        if (sym instanceof AtomicSymbol) {
            return dt.getCount(this, (AtomicSymbol)sym);
        }
        double totWeight = 0.0;
        Iterator<Symbol> asi = ((FiniteAlphabet)sym.getMatches()).iterator();
        while (asi.hasNext()) {
            AtomicSymbol as = (AtomicSymbol)asi.next();
            totWeight += dt.getCount(this, as);
        }
        return totWeight;
    }

    public void train() throws ChangeVetoException {
        Iterator i = this.trainers.iterator();
        while (i.hasNext()) {
            ((DistributionTrainer)i.next()).train(this, this.getNullModelWeight());
        }
    }

    public void clearCounts() {
        Iterator i = this.trainers.iterator();
        while (i.hasNext()) {
            ((DistributionTrainer)i.next()).clearCounts(this);
        }
    }
}

